﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Drawing;
using System.Drawing.Imaging;

namespace vr
{
    // сервис создания ico из температуры
    public class TempICO
    {
        public int WIDTH { get; private set; }
        public int HEIGHT { get; private set; }
        public float SIZE { get; private set; }

        public TempICO(int Width, int Height, float Size)
        {
            WIDTH = Width;
            HEIGHT = Height;
            SIZE = Size;
        }

        private byte[] CreatePicture(double Value)
        {
            Bitmap p = new Bitmap(WIDTH, HEIGHT, PixelFormat.Format32bppArgb);
            string s = Value.ToString("F0");
            using (Graphics g = Graphics.FromImage(p))
            {
                Color c = Color.LightYellow;
                if (Value > 0) c = Color.LightGreen;
                else if (Value < 0) c = Color.LightPink;
                g.Clear(c);
                Font f = new Font("Arial", SIZE, FontStyle.Bold);
                SizeF r = g.MeasureString(s, f);
                float x = (WIDTH - r.Width) / 2.0f;
                float y = (HEIGHT - r.Height) / 2.0f;
                g.DrawString(s, new Font("Arial", SIZE, FontStyle.Bold), Brushes.Black, x, y);
            }
            using (MemoryStream ps = new MemoryStream())
            {
                p.Save(ps, ImageFormat.Png);
                ps.Seek(0, SeekOrigin.Begin);
                return ps.ToArray();
            }
        }

        public byte[] ToBytes(double Value)
        {
            byte[] pb = CreatePicture(Value);
            using (MemoryStream ms = new MemoryStream())
            {
                BinaryWriter bw = new BinaryWriter(ms);

                // заголовок
                bw.Write(new byte[] { 0, 0 }); // заголовок, 2 байта, =0
                bw.Write(new byte[] { 1, 0 }); // тип, 2 байта, =1 (little endian)
                bw.Write(new byte[] { 1, 0 }); // кол-во изображений, =1

                // каталог
                bw.Write(Convert.ToByte(WIDTH)); // width, ширина в пикселях
                bw.Write(Convert.ToByte(HEIGHT)); // height, высота в пикселях
                bw.Write(Convert.ToByte(0)); // colors, кол-во цветов, для полноцветных =0
                bw.Write(Convert.ToByte(0)); // reserved, =0
                bw.Write(new byte[] { 1, 0 }); // planes, кол-во плоскостей, =1 (0)
                bw.Write(new byte[] { 32, 0 }); // bpp, бит пер пиксель
                bw.Write(Convert.ToInt32(pb.Length)); // size, размер изображения в байтах
                bw.Write(Convert.ToInt32(ms.Position + 4)); // offset, абсолютное смещение в файле

                // картинка
                bw.Write(pb);

                // возвращаем
                return ms.ToArray();
            }
        }

        public void ToFile(double Value, string Filename)
        {
            File.WriteAllBytes(Filename, ToBytes(Value));
        }

        public void ToStream(double Value, Stream St)
        {
            byte[] b = ToBytes(Value);
            St.Write(b, 0, b.Length);
        }

        public Icon ToIcon(double Value)
        {
            using (MemoryStream ms = new MemoryStream())
            {
                ToStream(Value, ms);
                ms.Seek(0, SeekOrigin.Begin);
                return new Icon(ms, WIDTH, HEIGHT);
            }
        }
    }
}
