﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Net;
using System.Text;
using System.Windows.Forms;

namespace vr
{
    public partial class Form1 : Form
    {
        private int w;
        private int h;
        private double t = 0;

        public Form1()
        {
            InitializeComponent();
            w = Width;
            h = Height;
            Left = Screen.PrimaryScreen.WorkingArea.Width - Width;
            Top = Screen.PrimaryScreen.WorkingArea.Height - Height;
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            Width = w;
            Height = h;
        }

        private void label1_MouseEnter(object sender, EventArgs e)
        {
            try { Opacity = 1.0; } catch { }
        }

        private void label1_MouseLeave(object sender, EventArgs e)
        {
            try { Opacity = 0.3; } catch { }
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            timer1.Enabled = false;
            try
            {
                using (WebClient wc = new WebClient())
                {
                    // получаем показания метеодатчика
                    string s = wc.DownloadString("https://ita.hldns.ru/tph/last");
                    // {"result":"06.09.2019 09:18:00|13.1|741|71","status":{"error":0,"message":""}}
                    // парсим ответ
                    int p1 = s.IndexOf(':');
                    p1 = s.IndexOf('"', p1) + 1;
                    int p2 = s.IndexOf('"', p1);
                    string[] f = s.Substring(p1, p2 - p1).Split(',');
                    for (int i = 0; i < f.Length; i++) f[i] = f[i].Trim();
                    string time = f[0].Split(' ')[2];
                    string T = f[2].Split(' ')[1];
                    try
                    {
                        string ts = T.Replace(".", System.Globalization.CultureInfo.CurrentCulture.NumberFormat.NumberDecimalSeparator);
                        ts = ts.Replace(",", System.Globalization.CultureInfo.CurrentCulture.NumberFormat.NumberDecimalSeparator);
                        t = double.Parse(ts);
                    }
                    catch { }
                    string P = f[3].Split(' ')[1];
                    string H = f[4].Split(' ')[1];
                    // показываем на форму
                    label4.Text = time;
                    label1.Text = "T=" + T;
                    label2.Text = "P=" + P;
                    label3.Text = "H=" + H;
                    label4.ForeColor = Color.Black;
                    // меняем иконку трэя
                    if (notifyIcon1.Visible) createicon();
                }
                timer1.Interval = 5 * 60 * 1000;
            }
            catch
            {
                label4.ForeColor=Color.Gray;
                timer1.Interval = 1 * 60 * 1000;
            }
            timer1.Enabled = true;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            timer1.Enabled = false;
            Close();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            WindowState = FormWindowState.Minimized;
            Hide();
            createicon();
            notifyIcon1.Visible = true;
        }

        private void notifyIcon1_Click(object sender, EventArgs e)
        {
            Show();
            WindowState = FormWindowState.Normal;
            notifyIcon1.Visible = false;
        }

        private void createicon()
        {
            notifyIcon1.Text = "t=" + t.ToString("F1");
            notifyIcon1.Icon = (new TempICO(16, 16, 7.0f)).ToIcon(t);
        }
    }
}
